<div class="modal fade" id="update-{{ $data->id }}" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-2">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <!--begin::Form-->
                <form type="POST" action="{{ route('admin-infopublik-update', ['id' => $data->id]) }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pilih Kategori</span>
                                </label>
                                <select name="kategori_id" id="kategori_id" class="form-control form-select{{ $errors->has('kategori_id') ? ' is-invalid' : '' }}">
                                    @foreach ($kategoris as $kategori)
                                    <option value="{{ $kategori->id }}" {{ $data->kategori_id==$kategori->id ? 'selected' : '' }}>{{ $kategori->nama }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('kategori_id'))
                                    <span class="invalid-feedback">{{ $errors->first('kategori_id') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tahun</span>
                                </label>
                                <input type="number" name="tahun" id="tahun" class="form-control{{ $errors->has('tahun') ? ' is-invalid' : '' }}" value={{ $data->tahun }}>
                                @if($errors->has('tahun'))
                                    <span class="invalid-feedback">{{ $errors->first('tahun') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Judul</span>
                                </label>
                                <input type="text" name="judul" id="judul" class="form-control{{ $errors->has('judul') ? ' is-invalid' : '' }}" value={{ $data->judul }}>
                                @if($errors->has('judul'))
                                    <span class="invalid-feedback">{{ $errors->first('judul') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File</span>
                                </label>
                                <input type="file" name="file" id="file" class="form-control{{ $errors->has('file') ? ' is-invalid' : '' }}">
                                @if($errors->has('file'))
                                    <span class="invalid-feedback">{{ $errors->first('file') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">File Terupload - <u class="text-primary">{{ $data->file }}</u></span>
                                </label>
                                <iframe src="{{ asset('assets/images/informasipublik/'.$data->file.'') }}" width="100px" height="100px"></iframe>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Keterangan</span>
                                </label>
                                <textarea name="deskripsi" id="deskripsi" class="form-control{{ $errors->has('deskripsi') ? ' is-invalid' : '' }}" rows="5">{{ $data->deskripsi }}</textarea>
                                @if($errors->has('deskripsi'))
                                    <span class="invalid-feedback">{{ $errors->first('deskripsi') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <!--end::Input group-->
                    <!--begin::Actions-->
                    <div class="text-center pt-5">
                        {{-- <button type="reset" id="kt_modal_new_card_cancel" class="btn btn-danger me-3">Batal</button> --}}
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>