@extends('admin.layouts.master')
@section('css')
<link href="{{ asset('assets/fileinput/css/fileinput.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link href="{{ asset('assets/fileinput/themes/explorer-fas/theme.css') }}" media="all" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">Profil</li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">Tambah</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <a href="{{ route('admin-profil-index') }}" class="btn btn-sm btn-info mb-2"><i class="bi bi-arrow-left me-1"></i> Kembali</a>
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Tambah Profil Desa</span>
                </h3>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <form action="{{route('admin-profil-store')}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Nama Desa</label>
                                <input type="hidden" class="form-control" name="pt_id" value="{{ Auth::user()->id }}" />
                                <input type="text" class="form-control" name="nama" placeholder="Masukan disini!" required/>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group mb-7">
                                <label class="form-label">Nama Singkat</label>
                                <input type="text" class="form-control" name="nama_singkat" placeholder="Masukan disini!"/>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="form-label">No. Tlp</label>
                                <input type="text" class="form-control" name="no_tlp" placeholder="Masukan disini!"/>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Email</label>
                                <input type="email" class="form-control" name="email" placeholder="Masukan disini!"/>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="required form-label">Alamat</label>
                                <input type="text" class="form-control" name="alamat" placeholder="Masukan disini!"/>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="form-label">Ucapan 1 <i>Ucapan 1 untuk dislide header</i></label>
                                <textarea name="ucapan1" class="form-control tox-target" rows="2" placeholder="Masukan disini!"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="form-label">Ucapan 2 <i>Ucapan 2 untuk dislide header</i></label>
                                <textarea name="ucapan2" class="form-control tox-target" rows="2" placeholder="Masukan disini!"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="required form-label">Peta Wilayah Desa</label>
                                <textarea name="peta_wilayah" class="form-control tox-target" rows="3" placeholder="Masukan disini!"></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="required form-label">Lokasi Kantor Desa</label>
                                <textarea name="lokasi_kantor_desa" class="form-control tox-target" rows="3" placeholder="Masukan disini!"></textarea>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Unggah Logo</label>
                                <div class="file-loading">
                                    <label>Preview File Icon</label>
                                    <input id="file-3" type="file" name="logo">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7">
                            <div class="form-group mb-7">
                                <label class="required form-label">Tentang Perusahaan</label>
                                <textarea name="tentang" id="kt-tinymce-4" class="tox-target"></textarea>
                            </div>
                        </div>
                    </div><hr>
                    <div class="text-center">
                        <button type="submit"class="btn btn-primary"><i class="fas fa-save fs-4 me-1"></i> Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')

<!-- Fileinput -->
<script src="{{ asset('assets/fileinput/js/plugins/piexif.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/plugins/sortable.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/fileinput.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/fr.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/es.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/fas/theme.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/explorer-fas/theme.js') }}" type="text/javascript"></script>

<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}"></script>
<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.js') }}"></script>
<script>
    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png", "svg"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
    });    
</script>
@endsection