<!-- /*
* Template Name: Property
* Template Author: Untree.co
* Template URI: https://untree.co/
* License: https://creativecommons.org/licenses/by/3.0/

* Customized by Yana Herdiana
*/ -->
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
  <head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="author" content="{{ $profil?->nama }}" />
    <link rel="shortcut icon" href="{{ asset('assets/media/logos/favicon.ico') }}" />

    <meta name="description" content="{{ $profil?->tentang }}" />
    <meta name="keywords" content="desa,desaid,desa panyutran,panyutran,sistem informasi desa,aplikasi desa,sistem manajemendesa, pangandaran, padaherang, batukaras, ciamis, banjar, pantai" />

    <title>{{ $tittle }} - {{ $profil?->nama }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Work+Sans:wght@400;500;600;700&display=swap" rel="stylesheet"/>

    <link rel="stylesheet" href="{{ asset('/guest/fonts/icomoon/style.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/fonts/flaticon/font/flaticon.css') }}" />

    <link rel="stylesheet" href="{{ asset('/guest/css/tiny-slider.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/css/aos.css') }}" />
    <link rel="stylesheet" href="{{ asset('/guest/css/style.css') }}" />
    <script type="text/javascript" src=https://widget.kominfo.go.id/gpr-widget-kominfo.min.js></script>
    <link rel="stylesheet" href="{{ asset('/guest/css/pricing.css') }}" />

    <style type="text/css">
      @import  url(https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css);
      .timeline {
      list-style: none;
      padding: 20px 0 20px;
      position: relative;
      }
      .timeline:before {
      top: 0;
      bottom: 0;
      position: absolute;
      content: " ";
      width: 3px;
      background-color: #eeeeee;
      left: 25px;
      margin-right: -1.5px;
      }
      .timeline > li {
      margin-bottom: 10px;
      position: relative;
      }
      .timeline > li:before,
      .timeline > li:after {
      content: " ";
      display: table;
      }
      .timeline > li:after {
      clear: both;
      }
      .timeline-panel {
      width: calc(100% - 75px);
      float: right;
      border: 1px solid #d4d4d4;
      border-radius: 2px;
      padding: 20px;
      position: relative;
      -webkit-box-shadow: 0 1px 6px rgba(0, 0, 0, 0.175);
      box-shadow: 0 1px 6px rgba(0, 0, 0, 0.175);
      }
      .timeline-panel:before {
      position: absolute;
      top: 26px;
      left: -15px;
      display: inline-block;
      border-top: 15px solid transparent;
      border-right: 15px solid #ccc;
      border-left: 0 solid #ccc;
      border-bottom: 15px solid transparent;
      content: " ";
      }
      .timeline-panel:after {
      position: absolute;
      top: 27px;
      left: -14px;
      display: inline-block;
      border-top: 14px solid transparent;
      border-right: 14px solid #fff;
      border-left: 0 solid #fff;
      border-bottom: 14px solid transparent;
      content: " ";
      }
      .timeline-badge {
      color: #fff;
      width: 50px;
      height: 50px;
      line-height: 50px;
      font-size: 1.4em;
      text-align: center;
      position: absolute;
      top: 16px;
      left: 0px;
      margin-right: -25px;
      background-color: #999999;
      z-index: 100;
      border-top-right-radius: 50%;
      border-top-left-radius: 50%;
      border-bottom-right-radius: 50%;
      border-bottom-left-radius: 50%;
      }

      .timeline-badge.primary {
      background-color: #2e6da4 !important;
      }
      .timeline-badge.success {
      background-color: #3f903f !important;
      }
      .timeline-badge.warning {
      background-color: #f0ad4e !important;
      }
      .timeline-badge.danger {
      background-color: #d9534f !important;
      }
      .timeline-badge.info {
      background-color: #5bc0de !important;
      }
    </style>

    @yield('css')
  </head>
  <body>
    <div class="site-mobile-menu site-navbar-target">
      <div class="site-mobile-menu-header">
        <div class="site-mobile-menu-close">
          <span class="icofont-close js-menu-toggle"></span>
        </div>
      </div>
      <div class="site-mobile-menu-body"></div>
    </div>
    @include('guest.item.navbar')
    @yield('content')
    @include('guest.item.footer')
    <!-- /.site-footer -->

    <!-- Preloader -->
    <div id="overlayer"></div>
    <div class="loader">
      <div class="spinner-border" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>

    <script src="{{ asset('/guest/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('/guest/js/tiny-slider.js') }}"></script>
    <script src="{{ asset('/guest/js/aos.js') }}"></script>
    <script src="{{ asset('/guest/js/navbar.js') }}"></script>
    <script src="{{ asset('/guest/js/counter.js') }}s"></script>
    <script src="{{ asset('/guest/js/custom.js/') }}"></script>
    @yield('js')
  </body>
</html>
