<div class="modal fade" id="nota-store" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Tambah <?php echo e($tittle); ?></h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-3">
                <?php if(count($errors) > 0): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <!--begin::Form-->
                <form type="POST" action="<?php echo e(route('admin-surat-store',['jenis'=>$jenis])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat Tugas</span>
                                </label>
                                <select name="surat_id" id="surat_id" class="form-control form-select<?php echo e($errors->has('surat_id') ? ' is-invalid' : ''); ?>">
                                    <?php
                                        use App\Models\Surat;
                                        $tugass = Surat::where('jenis','perintah')->orderBy('tgl_surat', 'desc')->get();
                                    ?>
                                    <?php $__currentLoopData = $tugass; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tugas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tugas->id); ?>"><?php echo e($tugas->nomor); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('surat_id')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('surat_id')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Nota Dinas</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_nota" id="tgl_nota" placeholder="Masukan disini!" value="<?php echo e(old('tgl_nota')); ?>"/>
                                <?php if($errors->has('tgl_nota')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tgl_nota')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat</span>
                                </label>
                                <input type="text" class="form-control" name="nomor" id="nomor" placeholder="Masukan disini!" value="<?php echo e(old('nomor')); ?>"/>
                                <?php if($errors->has('nomor')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('nomor')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pemberi Perintah</span>
                                </label>
                                <select name="pegawai_dl_ttd" id="pegawai_dl_ttd" class="form-control form-select<?php echo e($errors->has('pegawai_dl_ttd') ? ' is-invalid' : ''); ?>">
                                    <?php $__currentLoopData = $pegawais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pegawai->id); ?>"><?php echo e($pegawai->nama); ?> - <?php echo e($pegawai->jabatan); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('pegawai_dl_ttd')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('pegawai_dl_ttd')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Dasar Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="dasar_surat_dl" id="dasar_surat_dl" placeholder="Masukan disini!" value="<?php echo e(old('dasar_surat_dl')); ?>" rows="2"></textarea>
                                <?php if($errors->has('dasar_surat_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('dasar_surat_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tujuan DL</span>
                                </label>
                                <textarea type="text" class="form-control" name="tujuan_dl" id="tujuan_dl" placeholder="Masukan disini!" value="<?php echo e(old('tujuan_dl')); ?>" rows="2"></textarea>
                                <?php if($errors->has('tujuan_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tujuan_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pegawai DL</span>
                                </label>
                                <select name="pegawai_dl[]" id="pegawai_dl" multiple class="form-control form-select<?php echo e($errors->has('pegawai_dl') ? ' is-invalid' : ''); ?>">
                                    <?php $__currentLoopData = $pegawais; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pegawai): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($pegawai->id); ?>"><?php echo e($pegawai->nama); ?> - <?php echo e($pegawai->jabatan); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php if($errors->has('pegawai_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('pegawai_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tempat DL</span>
                                </label>
                                <textarea class="form-control" name="tempat_dl" id="tempat_dl" placeholder="Masukan disini!" rows="2" value="<?php echo e(old('tempat_dl')); ?>"></textarea>
                                
                                <?php if($errors->has('tempat_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tempat_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Kota/Kab/Kec Tempat DL</span>
                                </label>
                                <input type="text" class="form-control" name="kota_dl" id="kota_dl" placeholder="Masukan disini!" value="<?php echo e(old('kota_dl')); ?>">
                                <?php if($errors->has('kota_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('kota_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Angkutan yang digunakan</span>
                                </label>
                                <input type="text" class="form-control" name="angkutan_dl" id="angkutan_dl" placeholder="Masukan disini!" value="<?php echo e(old('angkutan_dl')); ?>">
                                <?php if($errors->has('angkutan_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('angkutan_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Kode Rekening Anggaran</span>
                                </label>
                                <input type="text" class="form-control" name="rek_anggaran_dl" id="rek_anggaran_dl" placeholder="Masukan disini!" value="<?php echo e(old('rek_anggaran_dl')); ?>">
                                <?php if($errors->has('rek_anggaran_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('rek_anggaran_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Berangkat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_berangkat_dl" id="tgl_berangkat_dl" placeholder="Masukan disini!" value="<?php echo e(old('tgl_berangkat_dl')); ?>">
                                <?php if($errors->has('tgl_berangkat_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tgl_berangkat_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Pulang</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_pulang_dl" id="tgl_pulang_dl" placeholder="Masukan disini!" value="<?php echo e(old('tgl_pulang_dl')); ?>"/>
                                <?php if($errors->has('tgl_pulang_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tgl_pulang_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Waktu</span>
                                </label>
                                <input type="time" class="form-control" name="waktu_dl" id="waktu_dl" placeholder="Masukan disini!" value="<?php echo e(old('waktu_dl')); ?>"/>
                                <?php if($errors->has('waktu_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('waktu_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span>Keterangan Lainnya</span><i>(Opsional)</i>
                                </label>
                                <textarea class="form-control" name="ket" id="ket" placeholder="Masukan disini!" rows="2" value="<?php echo e(old('ket')); ?>"></textarea>
                                <?php if($errors->has('ket')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('ket')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div><hr>
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/surat/item/nota-modal-store.blade.php ENDPATH**/ ?>