
<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container {
    width: 100% !important;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route($level.'-dashboard')); ?>" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted"><?php echo e($tittle); ?></li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#addModal" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="kematian-table" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center">Opsi</th>
                            <th class="align-middle">No. Tgl. Surat</th>
                            <th class="align-middle">Yang Meninggal</th>
                            <th class="align-middle">Tgl. Meninggal</th>
                            <th class="align-middle">Sebab, Tempat Meninggal</th>
                            <th class="align-middle">Pemakaman</th>
                            <th class="align-middle">Yang Menyatakan</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.SK.kematian.add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- Modal Update -->
<div class="modal fade" id="updateModal" tabindex="-1" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form action="" method="POST" id="updateForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="updateModalLabel">Edit Data SK Domisili</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4 mb-4">
                            <label for="update_no_surat" class="form-label">Nomor SK</label>
                            <input type="text" class="form-control" id="update_no_surat" name="no_surat" required placeholder="Isikan No. SK disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_tgl_surat" class="form-label">Tanggal SK</label>
                            <input type="date" class="form-control" id="update_tgl_surat" name="tgl_surat" required placeholder="Isikan Tanggal SK disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_nik" class="form-label">Yang Meninggal</label>
                            <select class="form-control select2" id="update_nik" name="nik" required>
                                <option value="">Pilih Penduduk Meninggal</option>
                                <?php $__currentLoopData = $penduduks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penduduk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($penduduk->id); ?>"><?php echo e($penduduk->id); ?> - <?php echo e($penduduk->nama_lengkap); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_tgl_kematian" class="form-label">Tanggal Kematian</label>
                            <input type="date" class="form-control" id="update_tgl_kematian" name="tgl_kematian" required placeholder="Isikan Tanggal disini..">
                        </div>
                        <div class="col-md-2 mb-4">
                            <label for="update_jam" class="form-label">Jam Kematian</label>
                            <input type="time" class="form-control" id="update_jam" name="jam" required placeholder="Isikan Jam Kematian disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_sebab" class="form-label">Penyebab Kematian</label>
                            <input type="text" class="form-control" id="update_sebab" name="sebab" required placeholder="Isikan Penyebab Kematian disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_tempat_kematian" class="form-label">Tempat Kematian</label>
                            <input type="text" class="form-control" id="update_tempat_kematian" name="tempat_kematian" required placeholder="Isikan Tempat Kematian disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_tempat_pemakaman" class="form-label">Tempat Pemakaman</label>
                            <input type="text" class="form-control" id="update_tempat_pemakaman" name="tempat_pemakaman" required placeholder="Isikan Tempat Pemakaman disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_sumber" class="form-label">Yang Memberi Info</label>
                            <input type="text" class="form-control" id="update_sumber" name="sumber" required placeholder="Isikan Yang Memberi Info disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_hubungan" class="form-label">Hubungan Pemberi Info</label>
                            <input type="text" class="form-control" id="update_hubungan" name="hubungan" required placeholder="Isikan Hubungan Pemberi Info disini..">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Modal Delete -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="POST" id="deleteForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?> <!-- Menggunakan metode DELETE untuk penghapusan -->
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Hapus Data SK Domisili</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body"> 
                    <p>Apakah Anda yakin ingin menghapus data SK Kematian ini?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
<script type="text/javascript">
    $('#addModal').on('shown.bs.modal', function() {
        $('#add_nik').select2({
            dropdownParent: $('#addModal')
        });
    });
    $(document).ready(function () {
        // Initialize DataTables
        var table = $('#kematian-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route(Auth::user()->level . '-sk-kematian-get-data')); ?>", // Route untuk mengambil data dari server
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'align-middle', orderable: false, searchable: false },
                { data: 'opsi', name: 'opsi', className: 'text-center align-middle', orderable: false, searchable: false },
                { data: 'tgl_surat_indo', name: 'tgl_surat_indo', className: 'align-middle' },
                { data: 'nik_nama', name: 'nik_nama', className: 'align-middle' },
                { data: 'tgl_kematian_indo', name: 'tgl_kematian_indo', className: 'align-middle' },
                { data: 'sebab_tempat', name: 'sebab_tempat', className: 'align-middle' },
                { data: 'tempat_pemakaman', name: 'tempat_pemakaman', className: 'align-middle' },
                { data: 'sumber', name: 'sumber', className: 'align-middle' }
            ],
            order: [[0, 'desc']],
        });

        // Handle edit button click
        $('#kematian-table').on('click', '.edit-kematian', function() {
            var id = $(this).data('id');
            var url = "<?php echo e(route(Auth::user()->level . '-sk-kematian-get-data-id', ':id')); ?>";
            url = url.replace(':id', id);

            $.get(url, function(data) {
                $('#update_no_surat').val(data.no_surat);
                $('#update_tgl_surat').val(data.tgl_surat);
                $('#update_nik').val(data.nik).trigger('change');
                $('#update_tgl_kematian').val(data.tgl_kematian);
                $('#update_jam').val(data.jam);
                $('#update_sebab').val(data.sebab);
                $('#update_tempat_kematian').val(data.tempat_kematian);
                $('#update_tempat_pemakaman').val(data.tempat_pemakaman);
                $('#update_sumber').val(data.sumber);
                $('#update_hubungan').val(data.hubungan);
                $('#updateForm').attr('action', "<?php echo e(route(Auth::user()->level . '-sk-kematian-update', ':id')); ?>".replace(':id', id));
                $('#updateModal').modal('show');
            });
        });

        // Inisialisasi Select2 untuk form update
        $('#update_nik').select2({
            dropdownParent: $('#updateModal')
        });

        // Klik tombol delete
        $('#kematian-table').on('click', '.delete-kematian', function() {
            var id = $(this).data('id');
            var url = "<?php echo e(route(Auth::user()->level . '-sk-kematian-delete', ':id')); ?>";
            url = url.replace(':id', id);

            // Set action form delete ke URL yang sesuai
            $('#deleteForm').attr('action', url);

            // Menampilkan modal delete
            $('#deleteModal').modal('show');
        });
        
    });   
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/SK/kematian/index.blade.php ENDPATH**/ ?>