<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Agenda;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class AgendaController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Agenda::all();
        $refsks = RefSK::all();
        return view('admin.agenda.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Agenda Desa');
    }

    public function store(Request $request){
        $request->validate([
            'jenis'      => 'required',
            'judul'      => 'required|string|max:255',
            'tempat'      => 'required|string|max:255',
            'tanggal'      => 'required|date',
            'jam'      => 'required|string|max:6',
        ]);

        $input = $request->all();
        $input['slug_judul'] = Str::slug($request->judul, '-');
        $simpan = Agenda::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-agenda-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'jenis'      => 'required',
            'judul'      => 'required|string|max:255',
            'tempat'      => 'required|string|max:255',
            'tanggal'      => 'required|date',
            'jam'      => 'required|string|max:6',
        ]);

        $simpan = Agenda::where('id', $id)->update([
            'jenis' => $request->jenis,
            'judul' => $request->judul,
            'slug_judul' => Str::slug($request->judul, '-'),
            'tempat' => $request->tempat,
            'tanggal' => $request->tanggal,
            'jam' => $request->jam,
            'deskripsi' => $request->deskripsi,
            'ket' => $request->ket,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-agenda-index');
    }

    public function delete($id) {
        $hapusdata = Agenda::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-agenda-index');
    }
}
