<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Informasipublik;
use App\Models\InformasipublikKategori;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use RealRashid\SweetAlert\Facades\Alert;

class InformasipublikController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $datas = Informasipublik::all();
        $kategoris = InformasipublikKategori::all();
        return view('admin.informasipublik.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'datas' => $datas,
            'kategoris' => $kategoris,
        ])->with('tittle', 'Informasi Publik');
    }

    public function store(Request $request){
        $request->validate([
            'kategori_id'   => 'required|integer',
            'judul'         => 'required|string|max:255',
            'tahun'         => 'required|integer',
            'file'          => 'required|mimes:pdf|max:4096',
        ]);

        $input = $request->all();
        if (empty($request->file)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('file');
            $nama_file = Str::slug($request->judul, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/informasipublik');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['file'] = $nama_file;
        $input['slug_judul'] = Str::slug($request->judul, '-');

        $simpan = Informasipublik::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-infopublik-index');
    }

    public function update(Request $request){
        // return $request;
        $request->validate([
            'kategori_id'   => 'required|integer',
            'judul'         => 'required|string|max:255',
            'tahun'         => 'required|integer',
        ]);

        $data = Informasipublik::where('id', $request->id)->first();
        
        if (empty($request->file)) {
            $nama_file = $data->file;
        } else {
            $image = $request->file('file');
            $nama_file = Str::slug($request->judul, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/informasipublik');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->file;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Informasipublik::where('id', $request->id)->update([
            'kategori_id' => $request->kategori_id,
            'judul' => $request->judul,
            'slug_judul' => Str::slug($request->judul, '-'),
            'file' => $nama_file,
            'deskripsi' => $request->deskripsi,
            'tahun' => $request->tahun,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-infopublik-index');
    }

    public function delete($id){
        $data = Informasipublik::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/informasipublik');
        $lokasi = $direktori.'/'.$data->file;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Informasipublik::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-infopublik-index');
    }

    public function store_kategori(Request $request){
        $request->validate([
            'nama'      => 'required|string|max:100',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        $input['slug_nama'] = Str::slug($request->nama, '-');

        $simpan = InformasipublikKategori::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-infopublik-index');
    }

    public function update_kategori(Request $request, $id){
        $request->validate([
            'nama'      => 'required|string|max:100',
        ]);

        $simpan = InformasipublikKategori::where('id', $id)->update([
            'nama' => strtoupper($request->nama),
            'slug_nama' => Str::slug($request->nama, '-'),
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-infopublik-index');
    }

    public function delete_kategori($id) {
        $hapusdata = InformasipublikKategori::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-infopublik-index');
    }
}
