<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Sotk;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class ProfilController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        if(Auth::user()->level=='admin'){
            $datas = Profil::all();
        }else{
            $datas = Profil::where('pt_id',Auth::user()->id)->get();
        }
        return view('admin.profil.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Pengelolaan Profil');
    }

    public function add(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        return view('admin.profil.add',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Tambah Profil');
    }

    public function store(Request $request){
        $request->validate([
            'nama'      => 'required',
            'alamat'      => 'required',
        ]);

        $input = $request->all();
        $input['nama'] = strtoupper($request->nama);
        if (empty($request->logo)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('logo');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/profil');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['logo'] = $nama_file;
        $input['slug_nama'] = Str::slug($request->nama, '-');

        $simpan = Profil::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-profil-index');
    }

    public function edit($id){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $data = Profil::whereId($id)->first();
        $refsks = RefSK::all();
        return view('admin.profil.edit',[
            'level' => $level,
            'profil' => $profil,
            'data' => $data,
            'refsks' => $refsks,
        ])->with('tittle', 'Edit Profil');
    }

    public function update(Request $request){
        $request->validate([
            'nama'      => 'required',
            'alamat'      => 'required',
        ]);

        $data = Profil::where('id', $request->id)->first();

        if (empty($request->logo)) {
            $nama_file = $data->logo;
        } else {
            $image = $request->file('logo');
            $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/profil');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->foto;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Profil::where('id', $request->id)->update([
            'pt_id' => $request->pt_id,
            'nama' => $request->nama,
            'nama_singkat' => $request->nama_singkat,
            'slug_nama' => Str::slug($request->nama, '-'),
            'alamat' => $request->alamat,
            'no_tlp' => $request->no_tlp,
            'email' => $request->email,
            'logo' => $nama_file,
            'tentang' => $request->tentang,
            'ucapan1' => $request->ucapan1,
            'ucapan2' => $request->ucapan2,
            'peta_wilayah' => $request->peta_wilayah,
            'lokasi_kantor_desa' => $request->lokasi_kantor_desa,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-profil-index');
    }

    public function delete($id){
        $data = Profil::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/profil');
        $lokasi = $direktori.'/'.$data->logo;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Profil::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-profil-index');
    }

    public function sotk(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $datas = Sotk::all();
        return view('admin.sotk.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'datas' => $datas,
        ])->with('tittle', 'Struktur Organisasi');
    }

    public function store_sotk(Request $request){
        $request->validate([
            'judul'      => 'required|string|max:100',
            'foto'      => 'required|mimes:png,jpg',
        ]);

        $input = $request->all();
        if (empty($request->foto)) {
            $nama_file = NULL;
        } else {
            $image = $request->file('foto');
            $nama_file = Str::slug($request->judul, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/profil');
            $image->move($tujuan_upload,$nama_file);
        }
        $input['foto'] = $nama_file;
        $input['slug_judul'] = Str::slug($request->judul, '-');

        $simpan = Sotk::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-sotk-sotk');
    }

    public function update_sotk(Request $request){
        // return $request;
        $request->validate([
            'judul'      => 'required|string|max:100',
            'foto'      => 'required|mimes:png,jpg',
        ]);

        $data = Sotk::where('id', $request->id)->first();
        
        if (empty($request->foto)) {
            $nama_file = $data->foto;
        } else {
            $image = $request->file('foto');
            $nama_file = Str::slug($request->nama, '-').'.'.$image->getClientOriginalExtension();
            $tujuan_upload = public_path('../public/assets/images/profil');
            $image->move($tujuan_upload,$nama_file);

            $lokasi = $tujuan_upload.'/'.$data->foto;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
        }

        $simpan = Sotk::where('id', $request->id)->update([
            'judul' => $request->judul,
            'slug_judul' => Str::slug($request->judul, '-'),
            'foto' => $nama_file,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-sotk-sotk');
    }

    public function delete_sotk($id){
        $data = Sotk::where('id', $id)->first();
        $direktori = public_path('../public/assets/images/profil');
        $lokasi = $direktori.'/'.$data->foto;
        if(File::exists($lokasi)) {
            File::delete($lokasi);
        }
        $eksekusi = Sotk::where('id', $id)->delete();

        if ($eksekusi) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-sotk-sotk');
    }
}
