<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Kwitansi;
use App\Models\NotaDinas;
use App\Models\Perangkat;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Surat;
// use Barryvdh\DomPDF\PDF as DomPDFPDF;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Str;
use Novay\WordTemplate\WordTemplate;
use RealRashid\SweetAlert\Facades\Alert;
use PDF;
class SuratController extends Controller
{
    public function index($jenis){
        if($jenis=="masuk"){
            $halaman = "Surat Masuk";
        }elseif($jenis=="keluar"){
            $halaman = "Surat Keluar";
        }elseif($jenis=="perintah"){
            $halaman = "Surat Tugas";
        }elseif($jenis=="nota"){
            $halaman = "Nota Dinas";
        }else{
            $halaman = "Kwitansi SPPD";
        }
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $pegawais = Perangkat::where('kelompok', "desa")->get();
        $datas = Surat::where('jenis', $jenis)->get();
        $notas = NotaDinas::all();
        $kwitansis = Kwitansi::all();
        return view('admin.surat.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'pegawais' => $pegawais,
            'datas' => $datas,
            'jenis' => $jenis,
            'notas' => $notas,
            'kwitansis' => $kwitansis,
        ])->with('tittle', $halaman);
    }

    public function tambah($jenis){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $surats = Surat::where('jenis','perintah')->orderBy('tgl_surat','desc')->get();
        return view('admin.surat.nota.store',[
            'jenis' => $jenis,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'surats' => $surats,
        ])->with('tittle', 'Tambah Nota Dinas');
    }

    public function edit($jenis, $id){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $surats = Surat::where('jenis','perintah')->orderBy('tgl_surat','desc')->get();
        $data = NotaDinas::where('id', $id)->first();
        return view('admin.surat.nota.update',[
            'jenis' => $jenis,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'surats' => $surats,
            'data' => $data,
        ])->with('tittle', 'Edit Nota Dinas');
    }

    public function store(Request $request, $jenis){
        if($jenis=='perintah'){
            $request->validate([
                'nomor'             => 'required|string|max:50',
                'dasar_surat_dl'    => 'required|string',
                'pegawai_dl_ttd'    => 'required|integer',
                'pegawai_dl'        => 'required',
                'tujuan_dl'         => 'required|string|max:255',
                'waktu_dl'          => 'required|string|max:50',
                'tempat_dl'         => 'required|string|max:255',
                'tgl_berangkat_dl'  => 'required',
                'tgl_pulang_dl'     => 'required',
                'tgl_surat'         => 'required',
                'kota_dl'           => 'required|string|max:30',
                'angkutan_dl'       => 'required|string|max:30',
                'rek_anggaran_dl'   => 'required|string|max:30',
            ]);

            $input = $request->all();
            $input['jenis'] = $jenis;
            $input['pegawai_dl'] = json_encode($request->pegawai_dl);
            $simpan = Surat::create($input);

        }elseif($jenis=='nota'){
            $request->validate([
                'surat_id'          => 'required',
                'tgl_nota'          => 'required',
                'penyelenggara'     => 'required|string|max:255',
                'acara'             => 'required|string|max:255',
                'peserta'           => 'required|string|max:1000',
                'hasil'             => 'required',
            ]);
            $input = $request->all();
            $simpan = NotaDinas::create($input);

        }elseif($jenis=='kwitansi'){
            
            $request->validate([
                'surat_id'          => 'required',
                'pegawai_id'        => 'required',
                'tgl_kwitansi'      => 'required',
                'uang_harian'       => 'required',
                'transport'         => 'required',
                'penginapan'        => 'required',
                'representatif'     => 'required',
            ]);
            if(empty($request->eviden)) {
                $input = $request->all();
                $simpan = Kwitansi::create($input);
            }else{
                $input = $request->all();
                $count=1;
                $image = $request->file('eviden');
                foreach($image as $f => $name){
                    $nama_file = date('dmYHis').'_'.$f.'.'.$name->getClientOriginalExtension();
                    $tujuan_upload = public_path('../public/assets/images/sppd');
                    $name->move($tujuan_upload,$nama_file);
                    $data[]=$nama_file;
                    $count++;
                }
                $input['eviden'] = json_encode($data);
                $simpan = Kwitansi::create($input);
            }

        }elseif($jenis=='masuk'){
            $request->validate([
                'perihal'       => 'required',
                'nomor'         => 'required|string|max:30',
                'tgl_surat'     => 'required',
                'tgl_terima'    => 'required',
                'asal_surat'    => 'required',
            ]);
            $input = $request->all();
            if (empty($request->file)) {
                $nama_file = NULL;
            } else {
                $image = $request->file('file');
                $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
                $tujuan_upload = public_path('../public/assets/images/surat/masuk');
                $image->move($tujuan_upload,$nama_file);
            }
            $input['file'] = $nama_file;
            $input['jenis'] = $jenis;
            $simpan = Surat::create($input);
        
        }elseif($jenis=='keluar'){
            $request->validate([
                'perihal'       => 'required',
                'nomor'         => 'required|string|max:30',
                'tgl_surat'     => 'required',
                'tujuan_surat'    => 'required',
            ]);
            $input = $request->all();
            if (empty($request->file)) {
                $nama_file = NULL;
            } else {
                $image = $request->file('file');
                $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
                $tujuan_upload = public_path('../public/assets/images/surat/keluar');
                $image->move($tujuan_upload,$nama_file);
            }
            $input['file'] = $nama_file;
            $input['jenis'] = $jenis;
            $simpan = Surat::create($input);

        }else{
            $request->validate([
                // 'jenis'      => 'required',
            ]);
        }

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-surat-index',['jenis'=>$jenis]);
    }

    public function update(Request $request, $jenis, $id){
        // return $request;
        if($jenis=='perintah'){
            $request->validate([
                'nomor'             => 'required|string|max:50',
                'dasar_surat_dl'    => 'required|string',
                'pegawai_dl_ttd'    => 'required|integer',
                'pegawai_dl'        => 'required',
                'tujuan_dl'         => 'required|string|max:255',
                'waktu_dl'          => 'required|string|max:50',
                'tempat_dl'         => 'required|string|max:155',
                'tgl_berangkat_dl'  => 'required',
                'tgl_pulang_dl'     => 'required',
                'tgl_surat'         => 'required',
                'kota_dl'           => 'required|string|max:30',
                'angkutan_dl'       => 'required|string|max:30',
                'rek_anggaran_dl'   => 'required|string|max:30',
            ]);

            $simpan = Surat::where('id', $id)->update([
                'jenis' => $jenis,
                'nomor' => $request->nomor,
                'dasar_surat_dl' => $request->dasar_surat_dl,
                'pegawai_dl_ttd' => $request->pegawai_dl_ttd,
                'pegawai_dl' => json_encode($request->pegawai_dl),
                'tujuan_dl' => $request->tujuan_dl,
                'waktu_dl' => $request->waktu_dl,
                'tempat_dl' => $request->tempat_dl,
                'tgl_berangkat_dl' => $request->tgl_berangkat_dl,
                'tgl_pulang_dl' => $request->tgl_pulang_dl,
                'tgl_surat' => $request->tgl_surat,
                'kota_dl' => $request->kota_dl,
                'angkutan_dl' => $request->angkutan_dl,
                'rek_anggaran_dl' => $request->rek_anggaran_dl,
            ]);

        }elseif($jenis=='nota'){
            $request->validate([
                'surat_id'      => 'required',
                'tgl_nota'      => 'required',
                'penyelenggara'      => 'required|string|max:255',
                'acara'      => 'required|string|max:255',
                'peserta'      => 'required|string|max:1000',
                'hasil'      => 'required',
            ]);
            
            $simpan = NotaDinas::where('id', $id)->update([
                'surat_id' => $request->surat_id,
                'tgl_nota' => $request->tgl_nota,
                'penyelenggara' => $request->penyelenggara,
                'acara' => $request->acara,
                'peserta' => $request->peserta,
                'hasil' => $request->hasil,
            ]);

        }elseif($jenis=='kwitansi'){
            $request->validate([
                'surat_id'          => 'required',
                'pegawai_id'          => 'required',
                'tgl_kwitansi'      => 'required',
                'uang_harian'       => 'required',
                'transport'         => 'required',
                'penginapan'        => 'required',
                'representatif'     => 'required',
            ]);
            if(empty($request->eviden)) {
                $simpan = Kwitansi::where('id', $id)->update([
                    'surat_id'      => $request->surat_id,
                    'pegawai_id'    => $request->pegawai_id,
                    'tgl_kwitansi'  => $request->tgl_kwitansi,
                    'uang_harian'   => $request->uang_harian,
                    'transport'     => $request->transport,
                    'penginapan'    => $request->penginapan,
                    'representatif' => $request->representatif,
                ]);
            }else{
                $evidenlama = Kwitansi::where('id', $request->id)->first();
                $count=1;
                $image = $request->file('eviden');
                $decode = json_decode($evidenlama->eviden);
                // fungsi hapus gambar di direktori
                foreach ($decode as $eviden) {
                    $path = public_path('assets/images/sppd');
                    $file_lama = $eviden;
                    $lokasi = $path.'/'.$file_lama;
                    if(File::exists($lokasi)) {
                        File::delete($lokasi);
                    }
                    $count++;
                }
                //fungsi simpan galeri
                foreach ($image as $f => $name) {
                    //simpan ke direktori
                    $nama_file = date('dmYHis').'_'.$f.'.'.$name->getClientOriginalExtension();
                    $tujuan_upload = public_path('../public/assets/images/sppd');
                    $name->move($tujuan_upload,$nama_file);
                    $data[]=$nama_file;
                    $count++;
                }
                $simpan = Kwitansi::where('id', $id)->update([
                    'surat_id'      => $request->surat_id,
                    'pegawai_id'    => $request->pegawai_id,
                    'tgl_kwitansi'  => $request->tgl_kwitansi,
                    'uang_harian'   => $request->uang_harian,
                    'transport'     => $request->transport,
                    'penginapan'    => $request->penginapan,
                    'representatif' => $request->representatif,
                    'eviden' 	    => json_encode($data),
                ]);
            }
        
        }elseif($jenis=="masuk"){
            $request->validate([
                'perihal'       => 'required',
                'nomor'         => 'required|string|max:30',
                'tgl_surat'     => 'required',
                'tgl_terima'    => 'required',
                'asal_surat'    => 'required',
            ]);
            $data = Surat::where('id', $request->id)->first();

            if (empty($request->file)) {
                $nama_file = $data->file;
            } else {
                $image = $request->file('file');
                $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
                $tujuan_upload = public_path('../public/assets/images/surat/masuk');
                $image->move($tujuan_upload,$nama_file);

                $lokasi = $tujuan_upload.'/'.$data->file;
                if(File::exists($lokasi)) {
                    File::delete($lokasi);
                }
            }

            $simpan = Surat::where('id', $request->id)->update([
                'jenis' => $jenis,
                'perihal' => $request->perihal,
                'nomor' => $request->nomor,
                'tgl_surat' => $request->tgl_surat,
                'tgl_terima' => $request->tgl_terima,
                'asal_surat' => $request->asal_surat,
                'file' => $nama_file,
            ]);

        }elseif($jenis=="keluar"){
            $request->validate([
                'perihal'       => 'required',
                'nomor'         => 'required|string|max:30',
                'tgl_surat'     => 'required',
                'tujuan_surat'    => 'required',
            ]);
            $data = Surat::where('id', $request->id)->first();

            if (empty($request->file)) {
                $nama_file = $data->file;
            } else {
                $image = $request->file('file');
                $nama_file = date('dmYHis').'.'.$image->getClientOriginalExtension();
                $tujuan_upload = public_path('../public/assets/images/surat/keluar');
                $image->move($tujuan_upload,$nama_file);

                $lokasi = $tujuan_upload.'/'.$data->file;
                if(File::exists($lokasi)) {
                    File::delete($lokasi);
                }
            }

            $simpan = Surat::where('id', $request->id)->update([
                'jenis' => $jenis,
                'perihal' => $request->perihal,
                'nomor' => $request->nomor,
                'tgl_surat' => $request->tgl_surat,
                'tujuan_surat' => $request->tujuan_surat,
                'file' => $nama_file,
            ]);

        }else{
            $request->validate([
                // 'jenis'      => 'required',
            ]);
        }

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-surat-index',['jenis'=>$jenis]);
    }

    public function delete($jenis,$id) {
        if($jenis=='note'){
            $hapusdata = NotaDinas::where('id', $id)->delete();
        }elseif($jenis=='kwitansi'){
            $hapusdata = Kwitansi::where('id', $id)->delete();
        }elseif($jenis=="masuk"){
            $data = Surat::where('id', $id)->first();
            $direktori = public_path('../public/assets/images/surat/masuk');
            $lokasi = $direktori.'/'.$data->file;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
            $hapusdata = Surat::where('id', $id)->delete();
        }elseif($jenis=="keluar"){
            $data = Surat::where('id', $id)->first();
            $direktori = public_path('../public/assets/images/surat/keluar');
            $lokasi = $direktori.'/'.$data->file;
            if(File::exists($lokasi)) {
                File::delete($lokasi);
            }
            $hapusdata = Surat::where('id', $id)->delete();
        }else{
            $hapusdata = Surat::where('id', $id)->delete();
        }

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-surat-index',['jenis'=>$jenis]);
    }

    public function cetak_st($jenis,$id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = Surat::where('id', $id)->first();
        $pegawai_ttd = Perangkat::where('id', $data->pegawai_dl_ttd)->first();
        
        return view('admin.surat.template.st-format',[
            'profil' => $profil,
            'data' => $data,
            'pegawai_ttd' => $pegawai_ttd,
        ]);
    }

    public function cetak_sppd($jenis,$id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = Surat::where('id', $id)->first();
        $pegawai_ttd = Perangkat::where('id', $data->pegawai_dl_ttd)->first();
        
        return view('admin.surat.template.sppd-format',[
            'profil' => $profil,
            'data' => $data,
            'pegawai_ttd' => $pegawai_ttd,
        ]);
    }

    public function cetak_sppd_2($jenis,$id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = Surat::where('id', $id)->first();
        $pegawai_ttd = Perangkat::where('id', $data->pegawai_dl_ttd)->first();
        
        return view('admin.surat.template.belakang-sppd',[
            'profil' => $profil,
            'data' => $data,
            'pegawai_ttd' => $pegawai_ttd,
        ]);
    }

    public function cetak_nota($jenis,$id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = NotaDinas::where('id', $id)->first();
        $surat = Surat::where('id', $data->surat_id)->first();
        $pegawai_ttd = Perangkat::where('id', $surat->pegawai_dl_ttd)->first();
        
        return view('admin.surat.template.nota-format',[
            'profil' => $profil,
            'data' => $data,
            'surat' => $surat,
            'pegawai_ttd' => $pegawai_ttd,
        ]);
    }

    public function cetak_kwitansi($jenis,$id){
        $profil = Profil::where('pt_id', 1)->first();
        $data = Kwitansi::where('id', $id)->first();
        $surat = Surat::where('id', $data->surat_id)->first();
        $pegawai_ttd = Perangkat::where('id', $surat->pegawai_dl_ttd)->first();
        $pegawai_dls = json_decode($surat->pegawai_dl);
        
        return view('admin.surat.template.kwitansi-format',[
            'profil' => $profil,
            'data' => $data,
            'surat' => $surat,
            'pegawai_ttd' => $pegawai_ttd,
            'pegawai_dls' => $pegawai_dls,
        ]);
    }
}
