<div class="modal fade" id="store" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Tambah {{ $tittle }}</h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-2 mx-xl-5 my-3">
                <!--begin::Form-->
                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form type="POST" action="{{ route('admin-agenda-store') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Pilih Jenis</span>
                                </label>
                                @php
                                    $jeniss=['Agenda Desa','Event'];
                                @endphp
                                <select name="jenis" id="jenis" class="form-control form-select{{ $errors->has('jenis') ? ' is-invalid' : '' }}">
                                    @foreach ($jeniss as $jenis)
                                    <option value="{{ $jenis }}">{{ $jenis }}</option>
                                    @endforeach
                                </select>
                                @if($errors->has('jenis'))
                                    <span class="invalid-feedback">{{ $errors->first('jenis') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Acara</span>
                                </label>
                                <input type="text" name="judul" id="judul" class="form-control{{ $errors->has('judul') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('judul'))
                                    <span class="invalid-feedback">{{ $errors->first('judul') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal</span>
                                </label>
                                <input type="date" name="tanggal" id="tanggal" class="form-control{{ $errors->has('tanggal') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('tanggal'))
                                    <span class="invalid-feedback">{{ $errors->first('tanggal') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Waktu</span>
                                </label>
                                <input type="time" name="jam" id="jam" class="form-control{{ $errors->has('jam') ? ' is-invalid' : '' }}" placeholder="Contoh: 12:00 WIB">
                                @if($errors->has('jam'))
                                    <span class="invalid-feedback">{{ $errors->first('jam') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tempat</span>
                                </label>
                                <input type="text" name="tempat" id="tempat" class="form-control{{ $errors->has('tempat') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('tempat'))
                                    <span class="invalid-feedback">{{ $errors->first('tempat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Deskripsi</span>
                                </label>
                                <textarea name="deskripsi" id="deskripsi" class="form-control{{ $errors->has('deskripsi') ? ' is-invalid' : '' }}" rows="4" placeholder="Masukan disini!"></textarea>
                                @if($errors->has('deskripsi'))
                                    <span class="invalid-feedback">{{ $errors->first('deskripsi') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="">Keterangan</span>
                                </label>
                                <textarea name="ket" id="ket" class="form-control{{ $errors->has('ket') ? ' is-invalid' : '' }}" rows="4" placeholder="Masukan disini!"></textarea>
                                @if($errors->has('ket'))
                                    <span class="invalid-feedback">{{ $errors->first('ket') }}</span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <!--begin::Actions-->
                    <div class="text-center pt-15">
                        {{-- <button type="reset" id="kt_modal_new_card_cancel" class="btn btn-danger me-3">Batal</button> --}}
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div>