@extends('admin.layouts.master')
@section('css')
<link href="{{ asset('assets/fileinput/css/fileinput.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link href="{{ asset('assets/fileinput/themes/explorer-fas/theme.css') }}" media="all" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">Tambah</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <a href="{{ route('admin-perangkat-index',['kelompok'=>$kelompok]) }}" class="btn btn-sm btn-info mb-2"><i class="bi bi-arrow-left me-1"></i> Kembali</a>
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">Form Tambah {{ $tittle }}</span>
                </h3>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                @if (count($errors) > 0)
                <div class="alert alert-danger">
                    <ul>
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
                @endif
                <form action="{{route('admin-perangkat-store',['kelompok'=>$kelompok])}}" method="post" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Kelompok</label>
                                <input type="hidden" name="kelompok" id="kelompok" class="form-control{{ $errors->has('kelompok') ? ' is-invalid' : '' }}" value="{{ $kelompok }}">
                                <select name="kelompok" id="kelompok" class="form-control form-select" disabled>
                                    <option value="{{ $kelompok }}">{{ $judul }}</option>
                                </select>
                                @if($errors->has('kelompok'))
                                    <span class="invalid-feedback">{{ $errors->first('kelompok') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Jabatan</label>
                                <input type="text" name="jabatan" id="jabatan" class="form-control{{ $errors->has('jabatan') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('jabatan'))
                                    <span class="invalid-feedback">{{ $errors->first('jabatan') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group mb-7">
                                <label class="required form-label">Nomor Induk Pegawai</label>
                                <input type="text" name="nomor_induk" id="nomor_induk" class="form-control{{ $errors->has('nomor_induk') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('nomor_induk'))
                                    <span class="invalid-feedback">{{ $errors->first('nomor_induk') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">NIK</label>
                                <input type="text" name="nik" id="nik" class="form-control{{ $errors->has('nik') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('nik'))
                                    <span class="invalid-feedback">{{ $errors->first('nik') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">Nama {{ $judul }}</label>
                                <input type="text" name="nama" id="nama" class="form-control{{ $errors->has('nama') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('nama'))
                                    <span class="invalid-feedback">{{ $errors->first('nama') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">Tempat Lahir</label>
                                <input type="text" name="tempat_lahir" id="tempat_lahir" class="form-control{{ $errors->has('tempat_lahir') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('tempat_lahir'))
                                    <span class="invalid-feedback">{{ $errors->first('tempat_lahir') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">Tanggal Lahir</label>
                                <input type="date" name="tgl_lahir" id="tgl_lahir" class="form-control{{ $errors->has('tgl_lahir') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('tgl_lahir'))
                                    <span class="invalid-feedback">{{ $errors->first('tgl_lahir') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">No. HP</label>
                                <input type="text" name="no_tlp" id="no_tlp" class="form-control{{ $errors->has('no_tlp') ? ' is-invalid' : '' }}" placeholder="Masukan disini!">
                                @if($errors->has('no_tlp'))
                                    <span class="invalid-feedback">{{ $errors->first('no_tlp') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group mb-7">
                                <label class="required form-label">Alamat</label>
                                <textarea name="alamat" id="alamat" class="form-control{{ $errors->has('alamat') ? ' is-invalid' : '' }}" placeholder="Masukan disini!"></textarea>
                                @if($errors->has('alamat'))
                                    <span class="invalid-feedback">{{ $errors->first('alamat') }}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group mb-7">
                                <label class="required form-label">Unggah Foto</label>
                                <div class="file-loading">
                                    <label>Preview File Icon</label>
                                    <input id="file-3" type="file" name="foto">
                                </div>
                            </div>
                        </div>
                    </div><hr>
                    <div class="text-center">
                        <button type="submit"class="btn btn-primary"><i class="fas fa-save fs-4 me-1"></i> Simpan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@section('js')

<!-- Fileinput -->
<script src="{{ asset('assets/fileinput/js/plugins/piexif.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/plugins/sortable.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/fileinput.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/fr.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/es.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/fas/theme.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/explorer-fas/theme.js') }}" type="text/javascript"></script>

<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.bundle.js') }}"></script>
<script src="{{ asset('assets/plugins/custom/tinymce/tinymce.js') }}"></script>
<script>
    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        allowedFileExtensions: ["jpg", "jpeg", "png"],
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
    });    
</script>
@endsection