@extends('guest.layouts.master')
@section('css')
@endsection
@section('content')
<div class="hero page-inner overlay"style="background-image: url({{ asset('guest/images/hero_bg_3.jpg') }})">
    <div class="container">
      <div class="row justify-content-center align-items-center">
        <div class="col-lg-9 text-center mt-5">
          <h1 class="heading" data-aos="fade-up">{{ $tittle }}</h1>
          <nav aria-label="breadcrumb"data-aos="fade-up"data-aos-delay="200">
            <ol class="breadcrumb text-center justify-content-center">
              <li class="breadcrumb-item"><a href="{{ route('beranda') }}">Beranda</a></li>
              <li class="breadcrumb-item active text-white-50"aria-current="page">{{ $tittle }}</li>
            </ol>
          </nav>
        </div>
      </div>
    </div>
</div>
<div class="section">
  <div class="container">
    <div class="row justify-content-between mb-5">
      <div class="col-md-8">
        <div class="row">
          @if (count($galeris)==0)
            <div class="alert alert-danger">
              <h4>Belum ada galeri yang ditambahkan!</h4>
            </div>
          @else
          @foreach ($galeris as $data)
          <div class="col-md-4 mb-3">
              @php
                  $sampul = json_decode($data->foto);

              @endphp    
              <div class="card" style=" height:20rem">
                  <img src="{{ asset('assets/images/galeri/'.$sampul[0]) }}" class="card-img-top" alt="{{ $data->slug_judul }}">
                  <div class="card-body">
                      <small class="text-dark"><i class="fa fa-camera"></i> {{count($sampul)}} Foto</small>
                      <h5 class="card-title mt-3"><a href="{{ url('/galeri/'.$data?->slug_judul.'') }}">{{ $data->judul }}</a></h5>
                  </div>
              </div>
          </div>
          @endforeach
          @endif
        </div>
        <nav>
          {{$galeris->links('guest.item.pagination')}}
        </nav>
      </div>
      <div class="col-md-4">
        @include('guest.item.side.populer')
        {{-- @include('guest.item.side.perangkat') --}}
      </div>
    </div>
  </div>
</div>
@endsection
@section('js')
@endsection