<div class="modal fade" id="note-update-<?php echo e($note->id); ?>" tabindex="-1" aria-hidden="true">
    <!--begin::Modal dialog-->
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <!--begin::Modal content-->
        <div class="modal-content">
            <!--begin::Modal header-->
            <div class="modal-header">
                <!--begin::Modal title-->
                <h2>Form Edit <?php echo e($tittle); ?></h2>
                <!--end::Modal title-->
                <!--begin::Close-->
                <div class="btn btn-sm btn-icon btn-active-color-primary" data-bs-dismiss="modal">
                    <!--begin::Svg Icon | path: icons/duotune/arrows/arr061.svg-->
                    <span class="svg-icon svg-icon-1">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                            <rect opacity="0.5" x="6" y="17.3137" width="16" height="2" rx="1" transform="rotate(-45 6 17.3137)" fill="black" />
                            <rect x="7.41422" y="6" width="16" height="2" rx="1" transform="rotate(45 7.41422 6)" fill="black" />
                        </svg>
                    </span>
                    <!--end::Svg Icon-->
                </div>
                <!--end::Close-->
            </div>
            <!--end::Modal header-->
            <!--begin::Modal body-->
            <div class="modal-body scroll-y mx-5 mx-xl-5 my-7">
                <?php if(count($errors) > 0): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <?php endif; ?>
                <!--begin::Form-->
                <form type="POST" action="<?php echo e(route('admin-surat-update', ['jenis'=>$jenis,'id' => $note->id])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <!--begin::Input group-->
                    <div class="row">
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Tanggal Surat</span>
                                </label>
                                <input type="date" class="form-control" name="tgl_surat" id="tgl_surat" p value=""/>
                                <?php if($errors->has('tgl_surat')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('tgl_surat')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Nomor Surat</span>
                                </label>
                                <input type="text" class="form-control" name="nomor" id="nomor" value=""/>
                                <?php if($errors->has('nomor')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('nomor')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="d-flex flex-column mb-7 fv-row">
                                <label class="d-flex align-items-center fs-6 fw-bold form-label mb-2">
                                    <span class="required">Dasar Surat</span>
                                </label>
                                <textarea type="text" class="form-control" name="dasar_surat_dl" id="dasar_surat_dl" rows="4"></textarea>
                                <?php if($errors->has('dasar_surat_dl')): ?>
                                    <span class="invalid-feedback"><?php echo e($errors->first('dasar_surat_dl')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div><hr>
                    <!--end::Input group-->
                    <!--begin::Actions-->
                    <div class="text-center pt-2">
                        <button type="reset" class="btn btn-danger">
                            <span class="indicator-label">Batal</span>
                        </button>
                        <button type="submit" class="btn btn-primary">
                            <span class="indicator-label">Simpan</span>
                        </button>
                    </div>
                    <!--end::Actions-->
                </form>
                <!--end::Form-->
            </div>
            <!--end::Modal body-->
        </div>
        <!--end::Modal content-->
    </div>
    <!--end::Modal dialog-->
</div><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/surat/item/nota-modal-update.blade.php ENDPATH**/ ?>