<?php

namespace App\Http\Controllers\Admin\Kependudukan;

use App\Http\Controllers\Controller;
use App\Models\Kk;
use App\Models\Penduduk;
use App\Models\Profil;
use App\Models\RefSK;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use RealRashid\SweetAlert\Facades\Alert;
use Yajra\DataTables\Facades\DataTables;

class KkController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        $penduduks = Penduduk::all();
        return view('admin.kependudukan.kk.index',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
            'penduduks' => $penduduks,
        ])->with('tittle', 'Data KK');
    }

    public function getKks(Request $request)
    {
        if ($request->ajax()) {
            $kks = Kk::query()
                ->join('penduduks', 'penduduks.no_kk', '=', 'kks.id')
                ->leftJoin('penduduks as kepala', 'kepala.id', '=', 'kks.kepala_kk')
                ->select(
                    'kks.id',
                    'kks.created_at',
                    'penduduks.no_kk',
                    'kepala.nama_lengkap as nama_kepala',
                    'kepala.id as nik_kepala',
                    DB::raw('COUNT(penduduks.id) as total') // Alias total untuk menghitung penduduk
                )
                ->groupBy('kks.id', 'kks.created_at', 'penduduks.no_kk', 'kepala.nama_lengkap', 'kepala.id')
                ->orderBy('kks.created_at', 'desc');

            return DataTables::of($kks)
                ->addIndexColumn()
                // Mengecualikan kolom 'total' dari pencarian
                ->filterColumn('total', function($query, $keyword) {
                    // Kolom 'total' tidak akan dicari
                })
                ->addColumn('opsi', function ($row) {
                    return '
                                <a href="javascript:void(0)" data-id="'.$row->id.'" class="btn btn-icon btn-sm btn-outline btn-outline-info text-hover-white mb-1 edit-kk">
                                    <i class="bi bi-pencil text-info fs-4" data-bs-toggle="tooltip" data-bs-custom-class="tooltip-dark" data-bs-placement="top" title="Update"></i>
                                </a>
                                <a href="javascript:void(0)" data-id="'.$row->id.'" class="btn btn-icon btn-sm btn-outline btn-outline-danger text-hover-white mb-1 delete-kk">
                                    <i class="bi bi-trash text-danger fs-4" data-bs-toggle="tooltip" title="Hapus"></i>
                                </a>
                            ';
                })
                ->addColumn('nik_nama_kepala', function($row) {
                    return $row->nik_kepala . '<br><strong>' . $row->nama_kepala . '</strong>';
                })
                ->rawColumns(['opsi', 'nik_nama_kepala'])
                ->make(true);
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'id' => 'required|unique:kks,id|max:16',
            'kepala_kk' => 'required|exists:penduduks,id',
        ]);
        
        $simpan = Kk::create([
            'id' => $request->id,
            'kepala_kk' => $request->kepala_kk,
        ]);
        if ($simpan) {
            Alert::success('Berhasil', 'Data KK berhasil ditambahkan.');
        }else {
            Alert::error('Gagal', 'Data KK gagal ditambahkan.');
        }

        return redirect()->route('admin-kependudukan-kk');
    }

    public function getKkid($id)
    {
        $kk = Kk::findOrFail($id);
        return response()->json($kk);
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'id' => 'required|max:16|unique:kks,id,' . $id,
            'kepala_kk' => 'required|exists:penduduks,id',
        ]);

        $kk = Kk::findOrFail($id);
        $simpan = $kk->update([
            'id' => $request->id,
            'kepala_kk' => $request->kepala_kk,
        ]);
        if ($simpan) {
            Alert::success('Berhasil', 'Data KK berhasil diperbarui.');
        }else {
            Alert::error('Gagal', 'Data KK gagal diperbarui.');
        }

        return redirect()->route('admin-kependudukan-kk');
    }

    public function delete($id)
    {
        $kk = Kk::findOrFail($id);
        $simpan = $kk->delete();

        if ($simpan) {
            Alert::success('Berhasil', 'Data KK berhasil dihapus!');
        }else {
            Alert::error('Gagal', 'Data KK gagal dihapus!');
        }

        return redirect()->route('admin-kependudukan-kk');
    }

    public function comingSoon(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $refsks = RefSK::all();
        // $refsk = RefSK::where('slug_nama', $slug)->first();
        return view('admin.coming-soon',[
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Coming Soon' );
    }
}
