<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Profil;
use App\Models\RefSK;
use App\Models\Sosmed;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use RealRashid\SweetAlert\Facades\Alert;
use Illuminate\Support\Str;

class SosmedController extends Controller
{
    public function index(){
        $level = Auth::user()->level;
        $profil = Profil::where('pt_id', 1)->first();
        $datas = Sosmed::all();
        $refsks = RefSK::all();
        return view('admin.sosmed.index',[
            'datas' => $datas,
            'level' => $level,
            'profil' => $profil,
            'refsks' => $refsks,
        ])->with('tittle', 'Tautan Terkait');
    }

    public function store(Request $request){
        $request->validate([
            'jenis'      => 'required',
            'nama'      => 'required|string|max:50',
        ]);

        $input = $request->all();
        $input['slug_nama'] = Str::slug($request->nama, '-');

        $simpan = Sosmed::create($input);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-sosmed-index');
    }

    public function update(Request $request, $id){
        $request->validate([
            'jenis'      => 'required',
            'nama'      => 'required|string|max:50',
        ]);

        $simpan = Sosmed::where('id', $id)->update([
            'jenis' => $request->jenis,
            'nama' => $request->nama,
            'slug_nama' => Str::slug($request->nama, '-'),
            'alamat_link' => $request->alamat_link,
        ]);

        if ($simpan) {
            Alert::success('Berhasil', 'Data Telah Disimpan');
        }else {
            Alert::error('Gagal', 'Data Tidak Disimpan');
        }
        return redirect()->route('admin-sosmed-index');
    }

    public function delete($id) {
        $hapusdata = Sosmed::where('id', $id)->delete();

        if ($hapusdata) {
            Alert::success('Berhasil', 'Data Telah Dihapus');
        } else {
            Alert::error('Gagal', 'Data Tidak Dihapus');
        }

        return redirect()->route('admin-sosmed-index');
    }
}
