<?php

namespace App\Http\Controllers;

use App\Models\Profil;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;

class AuthController extends Controller
{
    public function index()
    {
        if ($user = Auth::user()) {
            if ($user->level == 'admin' && $user->status == 'Aktif') {
                return redirect()->intended('admin');
            } elseif ($user->level == 'user' && $user->status == 'Aktif') {
                return redirect()->intended('user');
            }
        }
        $profil = Profil::where('pt_id', 1)->first();
        return view('login',[
            'profil' => $profil,
        ])->with('tittle', 'Login');
    }

    public function proses_login(Request $request)
    {
        request()->validate(
            [
                'username' => 'required',
                'password' => 'required',
            ]);

        $kredensil = $request->only('username','password');

            if (Auth::attempt($kredensil)) {
                $user = Auth::user();
                if ($user->level == 'admin' && $user->status == 'Aktif') {
                    return redirect()->intended('admin');
                } elseif ($user->level == 'user' && $user->status == 'Aktif') {
                    return redirect()->intended('user');
                }
                return redirect()->intended('/');
            }

        return redirect('login')
                                ->withInput()
                                ->withErrors(['login_gagal' => 'These credentials do not match our records.']);
    }

    public function logout(Request $request)
    {
       $request->session()->flush();
       Auth::logout();
       return Redirect('login');
    }
}
