@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container {
    width: 100% !important;
}
</style>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route($level.'-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">{{ $tittle }}</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List {{ $tittle }}</span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#addModal" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
                <table id="domisili-table" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="7%" class="align-middle">No</th>
                            <th class="align-middle text-center">Opsi</th>
                            <th class="align-middle">No. Surat</th>
                            <th class="align-middle">Tgl. Surat</th>
                            <th class="align-middle">Pemohon</th>
                            <th class="align-middle">Pekerjaan</th>
                            <th class="align-middle">Perihal</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
@include('admin.SK.domisili.add')
<!-- Modal Update -->
<div class="modal fade" id="updateModal" tabindex="-1" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form action="" method="POST" id="updateForm">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title" id="updateModalLabel">Edit Data SK Domisili</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-4 mb-4">
                            <label for="update_no_surat" class="form-label">Nomor SK</label>
                            <input type="text" class="form-control" id="update_no_surat" name="no_surat" required placeholder="Isikan No. SK disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_tgl_surat" class="form-label">Tanggal SK</label>
                            <input type="date" class="form-control" id="update_tgl_surat" name="tgl_surat" required placeholder="Isikan Tanggal SK disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_nik" class="form-label">Pemohon SK Domisili</label>
                            <select class="form-control select2" id="update_nik" name="nik" required>
                                <option value="">Pilih Pemohon SK Domisili</option>
                                @foreach($penduduks as $penduduk)
                                    <option value="{{ $penduduk->id }}">{{ $penduduk->id }} - {{ $penduduk->nama_lengkap }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_pekerjaan" class="form-label">Pekerjaan</label>
                            <input type="text" class="form-control" id="update_pekerjaan" name="pekerjaan" required placeholder="Isikan Pekerjaan disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_perihal" class="form-label">Keperluan SK</label>
                            <input type="text" class="form-control" id="update_perihal" name="perihal" required placeholder="Isikan Keperluan SK disini..">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- Modal Delete -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="POST" id="deleteForm">
                @csrf
                @method('DELETE') <!-- Menggunakan metode DELETE untuk penghapusan -->
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Hapus Data SK Domisili</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body"> 
                    <p>Apakah Anda yakin ingin menghapus data SK Domisili ini?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
<script type="text/javascript">
    $('#addModal').on('shown.bs.modal', function() {
        $('#add_nik').select2({
            dropdownParent: $('#addModal')
        });
    });
    $(document).ready(function () {
        // Initialize DataTables
        $('#domisili-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "{{ route(Auth::user()->level . '-sk-domisili-get-data') }}", // Route untuk mengambil data dari server
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'align-middle', orderable: false, searchable: false },
                { data: 'opsi', name: 'opsi', className: 'text-center align-middle', orderable: false, searchable: false },
                { data: 'no_surat', name: 'no_surat', className: 'align-middle' },
                { data: 'tgl_surat_indo', name: 'tgl_surat_indo', className: 'align-middle' },
                { data: 'nik_nama', name: 'nik_nama', className: 'align-middle' },
                { data: 'pekerjaan', name: 'pekerjaan', className: 'align-middle' },
                { data: 'perihal', name: 'perihal', className: 'align-middle' }
            ],
            order: [[0, 'desc']],
        });

        // Handle edit button click
        $('#domisili-table').on('click', '.edit-domisili', function() {
            var id = $(this).data('id');
            var url = "{{ route(Auth::user()->level . '-sk-domisili-get-data-id', ':id') }}";
            url = url.replace(':id', id);

            $.get(url, function(data) {
                $('#update_no_surat').val(data.no_surat);
                $('#update_tgl_surat').val(data.tgl_surat);
                $('#update_nik').val(data.nik).trigger('change');
                $('#update_pekerjaan').val(data.pekerjaan);
                $('#update_perihal').val(data.perihal);
                $('#updateForm').attr('action', "{{ route(Auth::user()->level . '-sk-domisili-update', ':id') }}".replace(':id', id));
                $('#updateModal').modal('show');
            });
        });

        // Inisialisasi Select2 untuk form update
        $('#update_nik').select2({
            dropdownParent: $('#updateModal')
        });

        // Klik tombol delete
        $('#domisili-table').on('click', '.delete-domisili', function() {
            var id = $(this).data('id');
            var url = "{{ route(Auth::user()->level . '-sk-domisili-delete', ':id') }}";
            url = url.replace(':id', id);

            // Set action form delete ke URL yang sesuai
            $('#deleteForm').attr('action', url);

            // Menampilkan modal delete
            $('#deleteModal').modal('show');
        });
        
    });   
</script>
@endsection