@extends('admin.layouts.master')
@section('css')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
{{-- <link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" /> --}}
<link href="{{ asset('assets/fileinput/css/fileinput.css') }}" media="all" rel="stylesheet" type="text/css"/>
<link href="{{ asset('assets/fileinput/themes/explorer-fas/theme.css') }}" media="all" rel="stylesheet" type="text/css"/>
@endsection
@section('content')
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1">{{ $tittle }}</h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="{{ route('admin-dashboard') }}" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted">Profil</li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        @foreach ($datas as $data)
        @php
            if (empty($data?->logo)) {
                $logo = "noimage.png";
            } else {
                $logo = $data?->logo;
            }
            $jumlahkarakter=150;
            $cetak = substr(strip_tags($data?->tentang), 0, $jumlahkarakter);
            $hasil = $cetak;
        @endphp
        <div class="card">
            <div class="card-header bg-secondary">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">PROFIL DESA</span>
                </h3>
                <div class="card-toolbar">
                    {{-- <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#store" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a> --}}
                    <a href="{{ route('admin-profil-add') }}" class="btn btn-sm btn-primary mx-2"><i class="bi bi-plus-lg me-1"></i> Tambah Profil</a>
                    <a href="{{ route('admin-profil-edit', ['id'=>$data?->id]) }}" class="btn btn-sm btn-warning"><i class="bi bi-pencil me-1"></i> Edit Profil</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5">
            
                <div class="row mb-2" style="bolder: 1px solid black">
                    <div class="col-md-4" >
                        <h3>Logo Desa</h3>
                        <img src="{{ asset('assets/images/profil/'.$logo.'') }}" alt="" width="300px">
                    </div>
                    <div class="col-md-8">
                        <table class="table table-striped table-bordered">
                            <tbody>
                                <tr>
                                    <th width="20%" class="text-left fs-4 px-2 fw-bolder">Nama Desa</th><td width="2%" class="text-center fs-4 fw-bolder">:</td><td class="text-left fs-4">{{ $data->nama }}</td>
                                </tr>
                                <tr>
                                    <th width="20%" class="text-left fs-4 px-2 fw-bolder">Nama Singkat</th><td width="2%" class="text-center fs-4 fw-bolder">:</td><td class="text-left fs-4">{{ $data->nama_singkat }}</td>
                                </tr>
                                <tr>
                                    <th width="20%" class="text-left fs-4 px-2 fw-bolder">Email Desa</th><td width="2%" class="text-center fs-4 fw-bolder">:</td><td class="text-left fs-4">{{ $data->email }}</td>
                                </tr>
                                <tr>
                                    <th width="20%" class="text-left fs-4 px-2 fw-bolder">No. Tlp Desa</th><td width="2%" class="text-center fs-4 fw-bolder">:</td><td class="text-left fs-4">{{ $data->no_tlp }}</td>
                                </tr>
                                <tr>
                                    <th width="20%" class="text-left fs-4 px-2 fw-bolder">Alamat Desa</th><td width="2%" class="text-center fs-4 fw-bolder">:</td><td class="text-left fs-4">{{ $data->alamat }}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <span class="card-title">Text Pada Slider Berada</span>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <span class="fs-3 fw-bolder">Ucapan 1</span>
                                        <p class="fs-4 fw-italic">"{{ $data->ucapan1 }}"</p>
                                    </div>
                                    <div class="col-md-6">
                                        <span class="fs-3 fw-bolder">Ucapan 2</span>
                                        <p class="fs-4 fw-italic">"{{ $data->ucapan2 }}"</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <span class="card-title">Peta Wilayah</span>
                            </div>
                            <div class="card-body">
                                <iframe src="{{ $data->peta_wilayah }}" width="500" height="400" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <span class="card-title">Peta Wilayah</span>
                            </div>
                            <div class="card-body">
                                <iframe src="{{ $data->lokasi_kantor_desa }}" width="500" height="400" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header">
                                <span class="card-title">Sekilas Tentang {{ $data->nama }}</span>
                            </div>
                            <div class="card-body">
                                {{ strip_tags($data->tentang) }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
{{-- @include('admin.profil.item.modal-store') --}}
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
{{-- <script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script> --}}

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Fileinput -->
<script src="{{ asset('assets/fileinput/js/plugins/piexif.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/plugins/sortable.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/fileinput.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/fr.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/js/locales/es.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/fas/theme.js') }}" type="text/javascript"></script>
<script src="{{ asset('assets/fileinput/themes/explorer-fas/theme.js') }}" type="text/javascript"></script>

<script>
    $(document).ready(function () {
        $('#datatable').DataTable({
            // "lengthMenu": [ [25, 50, 100, -1], [25, 50, 100, "All"] ],
            // "iDisplayLength": 25
        });
    });

    $("#file-3").fileinput({
        theme: 'fas',
        showUpload: false,
        showCaption: true,
        dropZoneEnabled: false,
        browseClass: "btn btn-primary btn-md",
        previewFileIcon: "<i class='glyphicon glyphicon-king'></i>",
        overwriteInitial: true,
        initialPreviewAsData: true,
    });    
</script>
@endsection