<?php
    use App\Models\Sosmed;
?>

<?php $__env->startSection('css'); ?>
<link href="https://cdn.datatables.net/1.13.1/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/css/select2.min.css" rel="stylesheet" />
<style>
    .select2-container {
    width: 100% !important;
}
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!--begin::Toolbar-->
<div class="toolbar mt-2" id="kt_toolbar">
    <!--begin::Container-->
    <div id="kt_toolbar_container" class="container-fluid d-flex flex-stack">
        <!--begin::Page title-->
        <div data-kt-swapper="true" data-kt-swapper-mode="prepend" data-kt-swapper-parent="{default: '#kt_content_container', 'lg': '#kt_toolbar_container'}" class="page-title d-flex align-items-center flex-wrap me-3 mb-5 mb-lg-0">
            <!--begin::Title-->
            <h1 class="d-flex align-items-center text-dark fw-bolder fs-3 my-1"><?php echo e($tittle); ?></h1>
            <!--end::Title-->
            <!--begin::Separator-->
            <span class="h-20px border-gray-300 border-start mx-4"></span>
            <!--end::Separator-->
            <!--begin::Breadcrumb-->
            <ul class="breadcrumb breadcrumb-separatorless fw-bold fs-7 my-1">
                <!--begin::Item-->
                <li class="breadcrumb-item text-muted">
                    <a href="<?php echo e(route('admin-dashboard')); ?>" class="text-muted text-hover-primary">Beranda</a>
                </li>
                <li class="breadcrumb-item">
                    <span class="bullet bg-gray-300 w-5px h-2px"></span>
                </li>
                <li class="breadcrumb-item text-muted"><?php echo e($tittle); ?></li>
                <!--end::Item-->
            </ul>
            <!--end::Breadcrumb-->
        </div>
        <!--end::Page title-->
    </div>
</div>
<!--begin::Post-->
<div class="post d-flex flex-column-fluid mt-0">
    <!--begin::Container-->
    <div class="container">
        <!--begin::Pricing card-->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title align-items-start flex-column">
                    <span class="card-label fw-bolder text-dark">List <?php echo e($tittle); ?></span>
                </h3>
                <div class="card-toolbar">
                    <a href="javascrip:void(0)" data-bs-toggle="modal" data-bs-target="#addModal" class="btn btn-sm btn-primary"><i class="bi bi-plus-lg me-1"></i> Tambah</a>
                </div>
            </div>
            <!--begin::Card body-->
            <div class="card-body p-lg-5 align-center">
                <table id="data-table" class="table table-striped table-row-bordered gy-4 gs-7 border rounded">
                    <thead>
                        <tr class="fw-bolder bg-secondary fs-6 text-gray-800 px-7">
                            <th width="4%" class="align-middle">No</th>
                            <th class="align-middle text-center" width="15%">Opsi</th>
                            <th class="align-middle text-center" width="">No. KK</th>
                            <th class="align-middle text-center">NIK</th>
                            <th class="align-middle text-center">NAMA LENGKAP</th>
                            <th class="align-middle text-center">TEMPAT TGL LAHIR</th>
                            <th class="align-middle text-center">JENIS KELAMIN</th>
                            <th class="align-middle text-center">AGAMA</th>
                            <th class="align-middle text-center">STATUS PERKAWINAN</th>
                            <th class="align-middle text-center">RT/RW</th>
                            <th class="align-middle text-center">DUSUN</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Update -->
<div class="modal fade" id="updateModal" tabindex="-1" aria-labelledby="updateModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <form action="" method="POST" id="updateForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="updateModalLabel">Edit Data Penduduk</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        
                        <div class="col-md-4 mb-4">
                            <label for="no_kk" class="form-label">No. Kartu Keluarga</label>
                            <input type="text" class="form-control" id="no_kk" name="no_kk" required maxlength="16" placeholder="Isikan NIK disini..">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="id" class="form-label">NIK</label>
                            <input type="text" class="form-control" id="id" name="id" required maxlength="16">
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="nama_lengkap" class="form-label">Nama Lengkap</label>
                            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" required maxlength="50">
                        </div>
                        <div class="col-md-3 mb-4">
                            <label for="tempat_lahir" class="form-label">Tempat Lahir</label>
                            <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" required>
                        </div>
                        <div class="col-md-3 mb-4">
                            <label for="tgl_lahir" class="form-label">Tanggal Lahir</label>
                            <input type="date" class="form-control" id="tgl_lahir" name="tgl_lahir" required>
                        </div>
                        <div class="col-md-3 mb-4">
                            <label for="update_jenis_kelamin" class="form-label">Jenis Kelamin</label>
                            <select class="form-control form-select" id="update_jenis_kelamin" name="jenis_kelamin" required>
                                <option value="L">LAKI-LAKI</option>
                                <option value="P">PEREMPUAN</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-4">
                            <label for="update_agama" class="form-label">Agama</label>
                            <select class="form-control form-select" id="update_agama" name="agama" required>
                                <option value="ISLAM">ISLAM</option>
                                <option value="KRISTEN">KRISTEN</option>
                                <option value="PROTESTAN">PROTESTAN</option>
                                <option value="HINDU">HINDU</option>
                                <option value="BUDHA">BUDHA</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="update_status_perkawinan" class="form-label">Status Perkawinan</label>
                            <select class="form-control form-select" id="update_status_perkawinan" name="status_perkawinan" required>
                                <option value="B">BELUM KAWIN</option>
                                <option value="S">SUDAH KAWIN</option>
                                <option value="P">PERNAH KAWIN</option>
                            </select>
                        </div>
                        <div class="col-md-4 mb-4">
                            <label for="dusun" class="form-label">Dusun</label>
                            <input type="text" class="form-control" id="dusun" name="dusun" required>
                        </div>
                        <div class="col-md-2 mb-4">
                            <label for="rw" class="form-label">RW</label>
                            <input type="number" class="form-control" id="rw" name="rw" required>
                        </div>
                        <div class="col-md-2 mb-4">
                            <label for="rt" class="form-label">RT</label>
                            <input type="number" class="form-control" id="rt" name="rt" required>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Delete -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="POST" id="deleteForm">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?> <!-- Menggunakan metode DELETE untuk penghapusan -->
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Hapus Data Penduduk</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body"> 
                    <p>Apakah Anda yakin ingin menghapus data Penduduk ini?</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php echo $__env->make('admin.kependudukan.penduduk.item.add', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.1/js/dataTables.bootstrap5.min.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.1.0-beta.1/js/select2.min.js"></script>
<script type="text/javascript">
    $('#addModal').on('shown.bs.modal', function() {
        $('#no_kk').select2({
            dropdownParent: $('#addModal')
        });
    });
    
    $(document).ready(function() {
        $('#data-table').DataTable({
            processing: true,
            serverSide: true,
            ajax: "<?php echo e(route(Auth::user()->level . '-kependudukan-get-penduduk')); ?>",
            columns: [
                { data: 'DT_RowIndex', name: 'DT_RowIndex', className: 'text-center align-middle', orderable: false, searchable: false }, // Nomor urut otomatis
                { data: 'opsi', name: 'opsi', className: 'text-center align-middle', orderable: false, searchable: false },
                { data: 'no_kk', name: 'no_kk', className: 'text-left align-middle' },
                { data: 'id', name: 'id', className: 'text-left align-middle' },
                { data: 'nama_lengkap', name: 'nama_lengkap', className: 'text-left align-middle' },
                { data: 'tgl_lahir_indo', name: 'tgl_lahir_indo', className: 'text-left align-middle' },
                { data: 'jenis_kelamin', name: 'jenis_kelamin', className: 'text-left align-middle' },
                { data: 'agama', name: 'agama', className: 'text-left align-middle' },
                { data: 'status_perkawinan', name: 'status_perkawinan', className: 'text-left align-middle' },
                { data: 'rt_rw', name: 'rt_rw', className: 'text-center align-middle' },
                { data: 'dusun', name: 'dusun', className: 'text-left align-middle' }
            ]
        });

        // Handle edit button click
        $('#data-table').on('click', '.edit-penduduk', function() {
            var id = $(this).data('id');
            var url = "<?php echo e(route(Auth::user()->level . '-kependudukan-get-penduduk-id', ':id')); ?>";
            url = url.replace(':id', id);

            $.get(url, function(data) {
                $('#id').val(data.id);
                $('#no_kk').val(data.no_kk);
                // if (data.no_kk) {
                //     $('#update_no_kk').val(data.no_kk).trigger('change');
                // } else {
                //     $('#update_no_kk').val('');
                //     $('#update_no_kk').attr('placeholder', 'Pilih No. Kartu Keluarga');
                // }
                $('#nama_lengkap').val(data.nama_lengkap);
                $('#tempat_lahir').val(data.tempat_lahir);
                $('#tgl_lahir').val(data.tgl_lahir);
                if (data.jenis_kelamin) {
                    $('#update_jenis_kelamin').val(data.jenis_kelamin).trigger('change');
                } else {
                    $('#update_jenis_kelamin').val('');
                    $('#update_jenis_kelamin').attr('placeholder', 'Pilih Jenis Kelamin');
                }
                if (data.agama) {
                    $('#update_agama').val(data.agama).trigger('change');
                } else {
                    $('#update_agama').val('');
                    $('#update_agama').attr('placeholder', 'Pilih Agama');
                }
                if (data.status_perkawinan) {
                    $('#update_status_perkawinan').val(data.status_perkawinan).trigger('change');
                } else {
                    $('#update_status_perkawinan').val('');
                    $('#update_status_perkawinan').attr('placeholder', 'Pilih Status Perkawinan');
                }
                $('#dusun').val(data.dusun);
                $('#rw').val(data.rw);
                $('#rt').val(data.rt);
                $('#updateForm').attr('action', "<?php echo e(route(Auth::user()->level . '-kependudukan-penduduk-update', ':id')); ?>".replace(':id', id));
                $('#updateModal').modal('show');
            });
        });

        // Inisialisasi Select2 untuk form update
        $('#update_no_kk').select2({
            dropdownParent: $('#updateModal')
        });

        // Klik tombol delete
        $('#data-table').on('click', '.delete-penduduk', function() {
            var id = $(this).data('id');
            var url = "<?php echo e(route(Auth::user()->level . '-kependudukan-penduduk-delete', ':id')); ?>";
            url = url.replace(':id', id);

            // Set action form delete ke URL yang sesuai
            $('#deleteForm').attr('action', url);

            // Menampilkan modal delete
            $('#deleteModal').modal('show');
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\desaid\resources\views/admin/kependudukan/penduduk/index.blade.php ENDPATH**/ ?>